%% Description
% Plots figure 8: dynamic adhesion test.

%% Experimental parameter definitions
%
% t             First column: wait time (s)
%               Second column: hold time (s)

clear all;close all;

%% Load solution
t = load('figure8.txt');

%% Plotting
semilogy(t(:,1),t(:,2),'bo')
xlabel('$t_{\mathrm{wait}}\,[\mathrm{s}]$','interpreter','latex')
ylabel('$t_{\mathrm{hold}}\,[\mathrm{s}]$','interpreter','latex')
set(findobj('type','axes'),'fontsize',20,'linewidth',2)
set(gca,'TickLength',2*get(gca,'TickLength'))
axis([0 20 1e0 1e6])

% Also, when twait = 15s, the load remained attached for more than 12 hours
hold on, plot(15,12*60*60,'b+')